#include <windows>
#pragma option push -a1
   #include <setupapi>
#pragma option pop
#include <iostream>
#include <assert>
#include "usb_R8_4.h"

using namespace std;
//--------------------------------------------------------------
TUSBDevice::TUSBDevice()
{
   memberIndex = 0;
   deviceInterfaceDetailData = NULL;
   hHidLib = NULL;
   hHidLib = LoadLibrary("C:\\Windows\\System32\\HID.DLL");
   if (!hHidLib)
     displayError("Bd doczenia biblioteki HID.DLL.");

   (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
   (FARPROC&) HidD_GetAttributes=GetProcAddress(hHidLib, "HidD_GetAttributes");

   if (!HidD_GetHidGuid || !HidD_GetAttributes){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }
}
//--------------------------------------------------------------
TUSBDevice::~TUSBDevice()
{
  if(hHidLib != NULL)
    FreeLibrary(hHidLib);
}
//--------------------------------------------------------------
void __stdcall TUSBDevice::displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//--------------------------------------------------------------
void __stdcall TUSBDevice::setUshortVid(USHORT vid)
{
  usVid = vid;
}
//--------------------------------------------------------------
void __stdcall TUSBDevice::setCharVid(const char* vid)
{
   chVid = vid;
}
//--------------------------------------------------------------
string __stdcall TUSBDevice::getUSBDevicePath(UINT)
{
   HidD_GetHidGuid(&classGuid);
   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData);
   SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
   deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
   deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

   if (SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)) {
       pathUSBDevice = deviceInterfaceDetailData->DevicePath;
       //cout << pathUSBDevice << endl;
   }
   releaseMemory(deviceInterfaceDetailData);
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   return pathUSBDevice;
}
//--------------------------------------------------------------
HANDLE __stdcall TUSBDevice::asynchOpenUSBDevice()
{
   string devUSBpath;
   HANDLE  hidDevObject = INVALID_HANDLE_VALUE;
   while((devUSBpath = getUSBDevicePath(memberIndex++)) != "" ){
     if (NULL != strstr(devUSBpath.c_str(), chVid)){
         cout << endl << devUSBpath <<endl;
         hidDevObject = CreateFile(devUSBpath.c_str(), GENERIC_READ | \
                          GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
                          NULL, OPEN_EXISTING, 0, NULL );
         if(hidDevObject != INVALID_HANDLE_VALUE)
           return  hidDevObject;
           break;
     }
     else
      if (memberIndex > searchMaxDevice)
        displayError("Nie znaleziono urzdzenia o podanym VID\n");
   }
   return  NULL;
}
//--------------------------------------------------------------
HANDLE __stdcall TUSBDevice::synchOpenUSBDevice()
{
   string devUSBpath;
   HANDLE  hidDevObject = INVALID_HANDLE_VALUE;
   while((devUSBpath = getUSBDevicePath(memberIndex++)) != "" ){
      hidDevObject = CreateFile(devUSBpath.c_str(), GENERIC_READ | \
                          GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,
                          NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL );

      HidD_GetAttributes(hidDevObject, &hiddAttributes);
      printf("VID/PID/wersja = %d/%d/%d\n",hiddAttributes.VendorID,
                                           hiddAttributes.ProductID,
                                           hiddAttributes.VersionNumber);

      if(hiddAttributes.VendorID == usVid){
         return hidDevObject;
         break;
      }
      else
        if(memberIndex > searchMaxDevice)
           displayError("Nie znaleziono urzdzenia o podanym VID");
   }
   return NULL;
}
//--------------------------------------------------------------
bool __stdcall TUSBDevice::asynchReadUSBReport(HANDLE hidDevObject,
           void *inputReportBuffer, ULONG inputReportBufferLength)
{
   numberOfBytesRead = 0;
   return ReadFile(hidDevObject, inputReportBuffer,
                   inputReportBufferLength, &numberOfBytesRead, NULL);
}
//--------------------------------------------------------------
bool __stdcall TUSBDevice::synchReadUSBReport(HANDLE hidDevObject,
               void *inputReportBuffer, ULONG inputReportBufferLength)
{
   result = 0;
   numberOfBytesRead = 0;
   OVERLAPPED *overlapped = NULL;
   if(overlapped == NULL){
      overlapped = new OVERLAPPED;
      overlapped->hEvent = CreateEvent(NULL, TRUE, TRUE, "");
      overlapped->Offset = 0;
      overlapped->OffsetHigh = 0;
   }
   if(!ReadFile(hidDevObject, inputReportBuffer, inputReportBufferLength,
                &numberOfBytesRead, overlapped)) {
      if(GetLastError() == ERROR_IO_PENDING) {
         result = WaitForSingleObject(overlapped->hEvent, INFINITE);
         if(result == WAIT_TIMEOUT) {
            CancelIo(hidDevObject);
            return false;
         }
         else
            if(result == WAIT_FAILED){
               cout << "Bd odczytu danych.";
               return false;
            }
            GetOverlappedResult(hidDevObject, overlapped,
                                &numberOfBytesRead, FALSE);
      }
      else
         displayError("Bd odczytu danych.");
   }
   ResetEvent(overlapped->hEvent);
   delete overlapped;
   return true;
}
//--------------------------------------------------------------
IUnknown *CreateInstance()
{
   IUnknown *p = (ISynchronous*)new TUSBDevice();
   p->AddRef();
   return p;
}
//---------------------------------------------------------------
HRESULT _stdcall TUSBDevice::QueryInterface(const IID& iid,
                                            void **Obj)
{
   if (iid == iidISynchronous)
     *Obj = (ISynchronous*)this; // wywouje elementy
                                 // interfejsu ISynchronous
     else
       if (iid == iidIAsynchronous)
        *Obj = (IAsynchronous*)this; // wywouje elementy
                                     // interfejsu IAsynchronous
        else {
          Obj = NULL;
          return E_NOINTERFACE;
        }
   ((IUnknown*)(*Obj))->AddRef();
   return S_OK;
}
//--------------------------------------------------------------
ULONG _stdcall TUSBDevice::AddRef()
{
   return InterlockedIncrement(&Addend);
}
//--------------------------------------------------------------
ULONG _stdcall TUSBDevice::Release()
{
   if (InterlockedDecrement(&Addend) == 0) {
     delete this;
     return 0;
   }
   return Addend;
}
//--------------------------------------------------------------
int main()
{
   HANDLE  hidDeviceObject;
   BYTE inputReportBuffer[bufferLength];

   HRESULT hr;
   // Inicjalizacja komponentu
   IUnknown *pUnknown = CreateInstance();

   // Synchroniczne operacje odczytu
   ISynchronous *pISynchronous = NULL;
   hr = pUnknown->QueryInterface(iidISynchronous, (void**)&pISynchronous);
   if (SUCCEEDED(hr)) {
      pISynchronous->setUshortVid(8890);
      hidDeviceObject = pISynchronous->synchOpenUSBDevice();
      while(true) {
          pISynchronous->synchReadUSBReport(hidDeviceObject,
                       inputReportBuffer, sizeof(inputReportBuffer));
          printf("%d %d %d %d %d %d %d\n", inputReportBuffer[0],
                 inputReportBuffer[1], inputReportBuffer[2],
                 inputReportBuffer[3], inputReportBuffer[4],
                 inputReportBuffer[5], inputReportBuffer[6]);
          if(inputReportBuffer[6]==64 || \
              hidDeviceObject == INVALID_HANDLE_VALUE){
              break;
         }
      }//koniec while
      pISynchronous->Release();
   };
/*
//  Asynchroniczne operacje odczytu
   IAsynchronous *pIAynchronous = NULL;
   hr = pUnknown->QueryInterface(iidIAsynchronous, (void**)&pIAynchronous);
   if (SUCCEEDED(hr)) {
      pIAynchronous->setCharVid("22ba");
      hidDeviceObject = pIAynchronous->asynchOpenUSBDevice();
      while(true) {
          pIAynchronous->asynchReadUSBReport(hidDeviceObject,
                      inputReportBuffer, sizeof(inputReportBuffer));
          printf("%d %d %d %d %d %d %d\n", inputReportBuffer[0],
                 inputReportBuffer[1], inputReportBuffer[2],
                 inputReportBuffer[3], inputReportBuffer[4],
                 inputReportBuffer[5], inputReportBuffer[6]);
          if(inputReportBuffer[6]==64 || \
             hidDeviceObject == INVALID_HANDLE_VALUE){
             break;
          }
      }//koniec while
     pIAynchronous->Release();
   };
*/
   CloseHandle(hidDeviceObject);
   pUnknown->Release();
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------------
 
